Attribute VB_Name = "BaseItem"
Option Explicit

Global gs_SAPCode As String
Global gi_BIConcurrency As Integer
Global gs_CGCode As String
Global gs_BIType As String

Global gi_BIGenConstants As Integer
Global gs_ItemView As String
'==== For Translation
Global gs_TranslationRight As String
'=== For workflow
Global gs_WorkFlow As String
'======= Constants ==========
Public Const gi_OutlLigneMax As Integer = 10000
Public Sub OptLength()
Dim li_Count As Integer

Select Case gs_CGCode
Case "Max"
    gs_MenuChoice = "Max. length"
    gs_ParamReq1 = "EXEC Estimate_Length_t_lst 'Max','"
Case "Min"
    gs_MenuChoice = "Max. length"
    gs_ParamReq1 = "EXEC Estimate_Length_t_lst 'Min','"
End Select

gs_TableName = "Estimate_Length"
gs_ParamReq2 = "EXEC Screen_Csts EstLength, '" & gut_LangLogin.Code & "'"
gs_ParamReq3 = "EXEC Check_Security Estimate_Length, " & prg.LoginName
gi_TranslateType = 1
gi_GridWidth(0) = 1
gi_GridWidth(1) = 1
gi_GridWidth(2) = 5000
gi_GridWidth(3) = 1000
gi_GridWidth(4) = 1000
For li_Count = 5 To 29
    gi_GridWidth(li_Count) = 1
Next li_Count
C_main.show 1

End Sub

Public Sub OptSlot()
Dim li_Count As Integer

gs_TableName = "Estimate_Slot"
Select Case gs_CGCode
Case "First"
    gs_MenuChoice = "First slot"
    gs_ParamReq1 = "EXEC Estimate_Slot_t_lst 'First','"
Case "Last"
    gs_MenuChoice = "Last slot"
    gs_ParamReq1 = "EXEC Estimate_Slot_t_lst 'Last','"
Case "Spacing"
    gs_MenuChoice = "Slot spacing"
    gs_ParamReq1 = "EXEC Estimate_Slot_t_lst 'Spacing','"
End Select

gs_ParamReq2 = "EXEC Screen_Csts EstSlot, '" & gut_LangLogin.Code & "'"
gs_ParamReq3 = "EXEC Check_Security Estimate_Slot, " & prg.LoginName
gi_TranslateType = 1
gi_GridWidth(0) = 1
gi_GridWidth(1) = 1
gi_GridWidth(2) = 5000
gi_GridWidth(3) = 1000
gi_GridWidth(4) = 1000
For li_Count = 5 To 29
    gi_GridWidth(li_Count) = 1
Next li_Count
C_main.show 1

End Sub
Public Sub OptGridType()
Dim li_Count As Integer

Select Case gs_CGCode
Case "C002"
    gs_MenuChoice = "Grid"
    gs_ParamReq1 = "EXEC Estimate_GridType_t_lst 'C002','"
    gs_ParamReq2 = "EXEC Screen_Csts EstType, '" & gut_LangLogin.Code & "'"
Case "C004"
    gs_MenuChoice = "Accessory grid"
    gs_ParamReq1 = "EXEC Estimate_GridType_t_lst 'C004','"
    gs_ParamReq2 = "EXEC Screen_Csts EstType4, '" & gut_LangLogin.Code & "'"
End Select

gs_TableName = "Estimate_GridType"
gs_ParamReq3 = "EXEC Check_Security Estimate_GridType, " & prg.LoginName
gi_TranslateType = 1
gi_GridWidth(0) = 1
gi_GridWidth(1) = 1
gi_GridWidth(2) = 5000
gi_GridWidth(3) = 1000
gi_GridWidth(4) = 1000
For li_Count = 5 To 29
    gi_GridWidth(li_Count) = 1
Next li_Count
C_main.show 1

End Sub


Public Sub InsertYear(ls_Year As String)

Dim ls_Req As String
Dim ll_Statement As Long
Dim li_Status As Integer
Dim ll_lngrows As Long

    On Error GoTo InsertYear
    
    ls_Req = "EXEC Item_Activity_ins '" _
        & QuoteParam(gs_SAPCode) & "', '" _
        & ls_Year & "'"
    If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
        li_Status = SQLRowCount(ll_Statement, ll_lngrows)
        li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
        If ll_lngrows = 0 Then
            SendMessage 4, "Insert failed", gut_LangLogin.Code
        End If
    Else
        li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    End If
    Exit Sub
    
InsertYear:
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    StdError
End Sub

Public Sub DeleteAllYear()
Dim ls_Req As String
Dim ll_Statement As Long
Dim li_Status As Integer
Dim ll_lngrows As Long

    On Error GoTo DeleteAllYear_Err
    
    ls_Req = "EXEC Item_Activity_del '" _
        & QuoteParam(gs_SAPCode) & "', 0" _
        & ""
    SQLSubmit gl_Environment, gl_Database, ll_Statement, ls_Req
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    
    Exit Sub
    
DeleteAllYear_Err:
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    StdError
End Sub

Public Function DeleteSourcing() As Boolean

Dim ls_Req As String
Dim ll_Statement As Long
Dim li_Status As Integer

DeleteSourcing = KO

On Error GoTo suite

ls_Req = " EXEC Base_Item_Sourcing_del '" _
    & gs_SAPCode & "', " & gi_BIConcurrency
If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    DeleteSourcing = OK
Else
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    SendMessage 7, "Delete failed : concurrency problem ?", gut_LangLogin.Code
End If
Exit Function

suite:
li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
StdError
End Function
Public Function CheckOrigin(ByVal ls_Armstrong As String, ByVal ls_Origin As String) As Boolean

CheckOrigin = OK
Select Case ls_Armstrong
Case "No"
    If ls_Origin <> "Not concerned" Then
        CheckOrigin = KO
    End If
Case Else
    If ls_Origin = "Not concerned" Then
        CheckOrigin = KO
    End If
End Select

End Function
Public Function External(l_Item As String) As Boolean

External = KO

On Error GoTo suite

If Not Existing_BI_Plants(l_Item) And Not Existing_BI_Suppliers(l_Item) Then
    External = OK
    Exit Function
End If

MouseOn
If SendMessage(54, "WARNING : Non ARMSTRONG product selected." & Chr(10) _
        & "Links to Plants & Suppliers will be deleted." & Chr(10) _
        & "Do you really want to delete these links ?", gut_LangLogin.Code, vbQuestion + vbYesNo, "Delete ") = vbNo Then
    MouseOff
    Exit Function
End If
MouseOff
If DeleteSourcing Then
    External = OK
End If
Exit Function

suite:
StdError
End Function
Public Function Manufactured(l_Item As String) As Boolean

Manufactured = KO

On Error GoTo suite

If Not Existing_BI_Suppliers(l_Item) Then
    Manufactured = OK
    Exit Function
End If

MouseOn
If SendMessage(55, "WARNING : Links to Suppliers will be deleted." & Chr(10) _
        & "Do you really want to delete these links ?", gut_LangLogin.Code, vbQuestion + vbYesNo, "Delete ") = vbNo Then
    MouseOff
    Exit Function
End If
MouseOff
If DeleteSourcing Then
    Manufactured = OK
End If
Exit Function

suite:
StdError
End Function
Public Function Purchased(l_Item As String) As Boolean

Purchased = KO

On Error GoTo suite

If Not Existing_BI_Plants(l_Item) Then
    Purchased = OK
    Exit Function
End If

MouseOn
If SendMessage(56, "WARNING : Links to Plants will be deleted." & Chr(10) _
        & "Do you really want to delete these links ?", gut_LangLogin.Code, vbQuestion + vbYesNo, "Delete ") = vbNo Then
    MouseOff
    Exit Function
End If
MouseOff
If DeleteSourcing Then
    Purchased = OK
End If
Exit Function

suite:
StdError
End Function
Public Function SourcingIntegrity(ByVal l_Arm As String, ByVal l_Ori As String) As Boolean

SourcingIntegrity = KO
Select Case UCase(l_Arm)
Case "NO"
    If Not External(gs_SAPCode) Then
        Exit Function
    End If
Case Else
    Select Case l_Ori
    Case "Manufactured"
        If Not Manufactured(gs_SAPCode) Then
            Exit Function
        End If
    Case "Purchased"
        If Not Purchased(gs_SAPCode) Then
            Exit Function
        End If
    End Select
End Select
SourcingIntegrity = OK

End Function
Public Function Existing_BI_Plants(ls_Item As String) As Boolean

Dim ls_Req As String
Dim ll_Statement As Long
Dim li_Status As Integer

On Error GoTo suite

Existing_BI_Plants = KO
ls_Req = "EXEC Base_Item_Plants_cnt '" _
    & QuoteParam(ls_Item) & "'"
If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
    li_Status = SQLFetch(ll_Statement)
    If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
        If CInt(ODBCData(ll_Statement, 1)) > 0 Then
            Existing_BI_Plants = OK
        End If
    End If
End If
li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
Exit Function

suite:
li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
StdError
End Function
Public Function Existing_BI_Suppliers(ls_Item As String) As Boolean

Dim ls_Req As String
Dim ll_Statement As Long
Dim li_Status As Integer

Existing_BI_Suppliers = KO

On Error GoTo suite

ls_Req = "EXEC Base_Item_Suppliers_cnt '" _
    & QuoteParam(ls_Item) & "'"
If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
    li_Status = SQLFetch(ll_Statement)
    If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
        If ODBCData(ll_Statement, 1) > "0" Then
            Existing_BI_Suppliers = OK
        End If
    End If
End If
li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
Exit Function

suite:
li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
StdError
End Function


Public Sub PbToSolve_Delete(li_RcdNumber As Long)

Dim ls_Req As String
Dim ll_Statement As Long
Dim li_Status As Integer
Dim ll_lngrows As Long

On Error GoTo suite

ls_Req = "EXEC Problems_ToSolve_del " & li_RcdNumber
If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
  li_Status = SQLRowCount(ll_Statement, ll_lngrows)
End If
li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
Exit Sub

suite:
li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
End Sub
